﻿# Skript zum Ändern des bisherigen einzigen Schüler-Users auf "non-admin"
# und Addieren eines neuen Users als "Eltern-Admin"

# --- Fenstergröße setzen (Breite/Höhe in Zeichen) ---
$Host.UI.RawUI.WindowSize = New-Object Management.Automation.Host.Size(80,20)

# Sicherheitsabfrage
$confirmation = Read-Host "!!! Dieses Script bitte `n nur auf den Schul-Laptops der 1A und 1B benützen!!! `n Soll das Script weiterlaufen? (Ja/Nein)"

if ($confirmation -ne "Ja") {
    Write-Host "❌ Skript wurde abgebrochen. `n Bitte nur auf den Schul-Laptops der 1A und 1B ausführen."
    exit
}
# --- Admin-Prüfung ---
if (-not ([Security.Principal.WindowsPrincipal] [Security.Principal.WindowsIdentity]::GetCurrent()).IsInRole(
    [Security.Principal.WindowsBuiltInRole] "Administrator")) {
    Add-Type -AssemblyName System.Windows.Forms
    [System.Windows.Forms.MessageBox]::Show("Bitte PowerShell als Administrator starten!`nDieses Skript benötigt erhöhte Rechte.",
                                            "Adminrechte fehlen", 'OK', 'Error')
    exit
}

# Funktion zum Erstellen eines lokalen Benutzers
function New-LocalUserCustom {
    param(
        [string]$UserName,
        [SecureString]$Password,
        [string]$Description = "",
        [bool]$IsAdmin = $false
    )

    $userExists = Get-LocalUser -Name $UserName -ErrorAction SilentlyContinue
    if ($userExists) {
        Write-Host "Hinweis: Benutzer ${UserName} existiert bereits."
    } else {
        try {
            New-LocalUser -Name $UserName -Password $Password -FullName $UserName -Description $Description -ErrorAction Stop
            Write-Host "Benutzer ${UserName} wurde erstellt."

            if ($IsAdmin) {
                Add-LocalGroupMember -Group "Administratoren" -Member $UserName -ErrorAction Stop
                Write-Host "Benutzer ${UserName} wurde zur Administratorgruppe hinzugefügt."
            } else {
                Add-LocalGroupMember -Group "Benutzer" -Member $UserName -ErrorAction Stop
                Write-Host "Benutzer ${UserName} wurde zur Benutzergruppe hinzugefügt."
            }
        }
        catch {
            Write-Host "Fehler beim Erstellen von ${UserName}: $($_.Exception.Message)"
        }
    }
}

try {
    # vorhandene Benutzer prüfen
    $users = Get-LocalUser
    Write-Host "Vorhandene Benutzerkonten:"
    $users | ForEach-Object { Write-Host " - $($_.Name)" }

    # Admin-Benutzer ermitteln (nur aktive Konten berücksichtigen)
    $adminsRaw = Get-LocalGroupMember -Group "Administratoren"
    $admins = @()

    foreach ($member in $adminsRaw) {
        $shortName = ($member.Name -split '\\')[-1]   # nur den reinen Benutzernamen extrahieren
        $localUser = Get-LocalUser -Name $shortName -ErrorAction SilentlyContinue
        if ($localUser -and $localUser.Enabled) { $admins += $shortName }
    }

    Write-Host "Aktive Administratoren: $admins"

    if ($admins.Count -eq 1) {
        $currentAdmin = $admins[0]
        Write-Host "Gefundener aktiver Admin: ${currentAdmin}"

        # Eltern-admin niemals herabstufen
        if ($currentAdmin -ieq 'eltern-admin') {
            Write-Host "Hinweis: eltern-admin ist der einzige aktive Admin und wird nicht herabgestuft."
        } else {
            try {
                Remove-LocalGroupMember -Group "Administratoren" -Member $currentAdmin -ErrorAction Stop
                Add-LocalGroupMember -Group "Benutzer" -Member $currentAdmin -ErrorAction Stop
                Write-Host "Benutzer ${currentAdmin} wurde von Admin zu Standard-Benutzer geändert."
            }
            catch {
                Write-Host "Fehler beim Ändern des Admin-Benutzers: $($_.Exception.Message)"
            }
        }
    }
    else {
        Write-Host "Kein eindeutiger aktiver Admin gefunden (Anzahl: $($admins.Count))."
    }

    # Eltern-admin absichern
    $eaName = 'eltern-admin'
    $ea = Get-LocalUser -Name $eaName -ErrorAction SilentlyContinue

    if (-not $ea) {
        $ElternAdminPassPlain = Read-Host "Bitte Passwort für eltern-admin eingeben `n (sichtbar, bitte aufschreiben!)"
        $ElternAdminPass = ConvertTo-SecureString $ElternAdminPassPlain -AsPlainText -Force
        New-LocalUserCustom -UserName $eaName -Password $ElternAdminPass -Description "Eltern Admin Benutzerkonto" -IsAdmin $true
        Write-Host "eltern-admin wurde neu angelegt und zum Admin gemacht."
    } else {
        if (-not $ea.Enabled) {
            Enable-LocalUser -Name $eaName
            Write-Host "eltern-admin wurde aktiviert."
        }

        $adminMembersShort = (Get-LocalGroupMember -Group 'Administratoren').Name |
            ForEach-Object { ($_ -split '\\')[-1] }

        if ($adminMembersShort -notcontains $eaName) {
            Add-LocalGroupMember -Group 'Administratoren' -Member $eaName -ErrorAction Stop
            Write-Host "eltern-admin wurde zur Administratorgruppe hinzugefügt."
        } else {
            Write-Host "eltern-admin ist bereits Administrator und aktiv."
        }
    }

    Write-Host "Vorgang abgeschlossen."
    Read-Host "Taste drücken zum Beenden..."
}
catch {
    Write-Host "Fehler im Skript: $($_.Exception.Message)"
}